async function dialog(title, message, opts) {
   opts ||= {};

   if(opts.prompt || opts.password) {
      const type = opts.password ? 'password' : 'text';
      message += `<input type="${type}" class="form-control" id="modal-text-input" style="margin-top: 5px">`;
      opts.buttonOk = true;
   }

   return new Promise(resolve => {
      $.confirm({
        template: opts.template ?? 'primary',
        templateOk: opts.template ?? 'primary',
        message: message,
        title: title,
        titleIcon: opts.titleIcon || 'glyphicon glyphicon-exclamation-sign',
        onOk: () => resolve((opts.prompt||opts.password) ? $('#modal-text-input').val() : true),
        onCancel: () => resolve(false),
        buttonOk: opts.buttonOk || false,
        labelOk: opts.labelOk||'Confirm',
        labelCancel: opts.labelCancel||'Close',
      });
   });
}
