async function openFileDialog(opts) {
   return new Promise(resolve => {
      $('<input type="file" multiple="multiple">').click().change(evt => resolve(evt.target.files));
   });
}

class MultiSelector {
   constructor(element, opts) {
      this.element = element;
      this.files = [];
      this.oncomplete = opts.oncomplete;
      $(this.element).find('.browsebtn')
         .click(async evt => this.addFiles(await openFileDialog()))
         .css('cursor', 'pointer');
   }
   addFiles(files) {
      for(const file of files) {
         const idx = this.files.length;
         $(this.element).find('.files_list').append(`
            <table><tr class="xrow" id="file_${idx}_options"><td>
               <font class="xfname">${file.name}</font>
               <font class="xfsize">(${convertSize(file.size)})</font>
               <a href="#" class="delete" title="Delete"><img class="del_btn" src="images/icon_delete.png"></a>
               <br>
               Description:
               <input type="text" class="fdescr" maxlength="48" option-name="file_descr">
               <label class="xdescr">
                  <input type="checkbox" value="1" option-name="file_public" checked="checked">
                  Public
               </label>
            </td></tr></table>
         `);
         $(`#file_${idx}_options .delete`).click(evt => {
            evt.preventDefault();
            $(`#file_${idx}_options`).remove();
            this.files[idx] = null;
         });
         this.files.push(file);
      }
      if(!this.uploadControlsInstalled()) this.installUploadControls();
   }
   uploadControlsInstalled() {
      return $(this.element).find('#upload_controls').length > 0;
   }
   installUploadControls() {
      $(this.element).append(`
         <div id="show_advanced" style="width: 485px;"><a href="#">Show advanced</a></div>
         <div id="upload_controls" style="display: inline-block; text-align: left; margin-bottom: 20px">
            <input type="button" id="add_more" value="Add more">
            <input type="button" style="float: right;" name="upload" value="Start upload">
         </div>
      `);
      $(this.element).find('input[name=upload]').click(() => {
         console.log("Start upload");
         $('#show_advanced').hide();
         $('.advanced_opts').hide();
         $('.xrow').hide();
   
         const entries = $(this.files).map((idx, file) => {
            if(file === null) return;
            let ret = { file: file, options: {} };
            $(`#file_${idx}_options input`).each((_, input) => ret.options[input.getAttribute('option-name')] = input.value);
            return ret;
         });
         this.oncomplete(entries.toArray());
      });
      $(this.element).find('#show_advanced').click(evt => { $('.advanced_opts').show(); evt.preventDefault() });
      $(this.element).find('#add_more').click(async evt => this.addFiles(await openFileDialog()));
      $(this.element).find('.browsebtn').hide();
   }
}
