class ProgressTracker {
   constructor(element, opts) {
      this.element = element;
      this.loaded = 0;

      $(this.element).html(`
         <div class="progressbar-outer progress">
            <div class="progressbar-inner progress-bar progress-bar-striped active" role="progressbar"></div>
         </div>
         <br>
         <div class="progressbar-filenames"><b>${opts.filenames.join(", ")}</b></div>
         <div class="progressbar-completed"></div>
         <div class="progressbar-speed">Upload speed: <span class="value" style="font-weight: bold">0 Kb/s</span></div>
         <a href="javascript:false" class="abort">Abort</a>
      `);

      if(opts?.onabort) $(this.element).find('.abort').click(opts.onabort);
   }
   reset() {
      this.ts = Date.now();
   }
   update(loaded, total) {
      console.log(`update(${loaded}, ${total})`);
      $(this.element).find('.progressbar-inner').width(Math.round((loaded / total) * $('.progressbar-outer').width()));

      if(!this.ts) this.ts = Date.now();
      const dt = Date.now() - this.ts;
      if(dt < 1000) return;

      const speed = 1000 * (loaded - this.loaded) / dt;
      $(this.element).find('.progressbar-speed .value').html(`${convertSize(speed)}/s`);
      this.ts = Date.now();
      this.loaded = loaded;
   }
}
