async function uploadFile(file, prerequest_ret, upload_request) {
   console.log("uploadFile", file, prerequest_ret, upload_request);
   const sid = Array(16).fill().map(() => Math.floor(Math.random() * 10)).join("");

   const DEFAULT_CHUNK_SIZE = 100 * 1024 * 1024; // Cloudflare
   const chunkSize = upload_request.chunkSize || DEFAULT_CHUNK_SIZE;
   const chunkCount = Math.max(1, Math.ceil(file.size / chunkSize));
   console.log(`Uploading in ${chunkCount} chunk(s) of up to ${chunkSize} bytes`);

   for (let index = 0; index < chunkCount; index++) {
      const start = index * chunkSize;
      const end = Math.min(start + chunkSize, file.size);
      const xhr = await put(`${prerequest_ret.url}/put_chunk.cgi`, file.slice(start, end), {
         'onuploadprogress': evt => { upload_request.onuploadprogress({ loaded: start + evt.loaded, total: file.size }) },
         'headers': {
            'Content-type': 'application/octet-stream',
            'X-Upload-SID': sid,
         }
      });
      const upload_ret = JSON.parse(xhr.responseText);
      console.log("Chunk upload result:", upload_ret);
   }

   const import_request = {
      op: 'import_file',
      sid: sid,
      fname: upload_request.file.name,
      ...upload_request.passthrough||{}
   };

   console.log("import request:", import_request);
   const import_ret = await post(`${prerequest_ret.url}/api.cgi`, import_request);
   console.log("import_ret:", import_ret);
   return import_ret;
}

uploadPlugins['xfspro'] = uploadFile;
