let uploadPlugins = {};
let app = angular.module('UploaderApp', []);
app.controller('UploaderCtrl', function($scope) {
   console.log("App started");
   $scope.fileUploader = {
      uploadStarted: false,
      uploadedCount: 0,
      files: [],
      fileCodes: [],
      opts: {},

      downloadLinks: "",
      shortLinks: "",
      deleteLinks: "",
      htmlCodes: "",
      forumCodes: "",
   };
   $scope.convertSize = convertSize;
   $scope.percent = file => Math.floor(100 * file.loaded / file.size);
   $scope.computeHeight = function() {
      const expander = Math.min(2, Math.max(0, $scope.fileUploader.uploadedCount - 1));
      return (4 + expander * 1.7) + 'em';
   };
   $scope.fileUploader.startUpload = async function() {
      console.log("Advanced options:", $scope.fileUploader.opts);
      console.log("startUpload");
      $scope.fileUploader.uploadStarted = true;

      let i = 0;
      while(i < $scope.fileUploader.files.length) {
         console.log("i = ", i, "len =", $scope.fileUploader.files.length);
         const file = $scope.fileUploader.files[i];
         console.log("Uploading file", file);

         const prerequest_ret = await post('/', {
            op: "start_upload",
            file_name: file.name,
            file_descr: file.descr || "",
            file_public: file.public ? 1 : 0,
            file_size: file.size,
         });

         console.log("Got from main server:", prerequest_ret);

         let t = Date.now();
         let l = 0;
         const onuploadprogress = function(evt) {
            console.log(evt);
            file.loaded = evt.loaded;

            const dt = Date.now() - t;
            const dl = file.loaded - l;
            if(dt >= 1000) {
               t = Date.now();
               l = file.loaded;
               file.speed = 1000 * dl / dt;
               console.log("dl = ", dl, "dt = ", dt);
            }

            $scope.$apply();
         };

         const upload_request = {
            file: file,
            onuploadprogress: onuploadprogress,
            passthrough: {
               sess_id: $scope.sess_id,
               file_descr: file.descr || "",
               file_public: file.public ? 1 : 0,
               link_rcpt: $scope.fileUploader.opts.link_rcpt || "",
               link_pass: $scope.fileUploader.opts.link_pass || "",
               to_folder: $scope.fileUploader.opts.to_folder || "",
            }
         };
         const uploader = uploadPlugins[prerequest_ret.plugin];
         if(!uploader) {
            console.log(`No plugin for ${prerequest_ret.plugin}`);
            return;
         }
         const import_ret = await uploader(file, prerequest_ret, upload_request);

         console.log("import_ret:", import_ret);

         if(import_ret.status == 'OK') {
            $scope.fileUploader.fileCodes.push(import_ret.file_code);
            $scope.fileUploader.downloadLinks += import_ret.links.download_link + "\n";
            $scope.fileUploader.shortLinks += (import_ret.links.short_link||"") + "\n";
            $scope.fileUploader.deleteLinks += import_ret.links.delete_link + "\n";
            $scope.fileUploader.forumCodes += import_ret.links.forum_code + "\n";
            $scope.fileUploader.htmlCodes += import_ret.links.html_code + "\n";
            $scope.fileUploader.uploadedCount++;
            $scope.fileUploader.files.splice(i, 1);
            $scope.$apply();
         } else {
            console.log("upload failed");
            file.error = import_ret.error;
            $scope.$apply();
            i++;
         }
      }
      $scope.fileUploader.uploadEnded = true;
      $scope.$apply();
      if($scope.fileUploader.opts.link_rcpt && $scope.fileUploader.fileCodes) {
         console.log(`Sending e-mail to ${$scope.fileUploader.opts.link_rcpt}`);
         const query = $scope.fileUploader.fileCodes.map(code => `st=OK&fn=${code}`).join("&");
         $.ajax(`/?op=upload_result&link_rcpt=${escape($scope.fileUploader.opts.link_rcpt)}&${query}`)
      }
   };
   $scope.deleteFile = idx => {
      $scope.fileUploader.files.splice(idx, 1);
      $scope.fileUploader.error = '';
   };
});
